unit catgrid;
// opcenito za prikaz productsa
interface

uses SysUtils, System.Data, System.Web.UI, StrUtils, System.Drawing, System.Web.UI.WebControls;

Type TShowBy = (sbDeveloper, sbAppType, sbAppPayType); //po cemu prikazije nebili NE prikazao taj pri pregledu


type TCatGrid = Class(System.Web.UI.WebControls.DataGrid)
	private
		fShowBy : TShowBy;
		procedure SetShowBy(Value : TShowBy);
	public
    constructor Create; 
    procedure MyOnPageIndexChanged(Sender: System.Object; e : DataGridPageChangedEventArgs);
    procedure MyOnItemCreated(sender : System.Object; e : DataGridItemEventArgs);
		
		property ShowBy : TShowBy read fShowBy write SetShowBy;
end;


implementation

var gShowBy : TShowBy; //global nebil mogo pristupit iz ITEmpl clase

procedure TCatGrid.SetShowBy(Value : TShowBy);
begin
	if fShowBy<>value then
	begin 
		fShowBy := Value;
		gShowBy := fShowBy;
	end;
end;

type
  TItemTemplate = Class(System.Object,ITemplate)
     procedure InstantiateIn(container:System.Web.UI.Control);
     procedure DoDataBinding(Sender: System.Object; E: System.EventArgs);
end;

procedure TItemTemplate.DoDataBinding(Sender: System.Object; E:System.EventArgs);
var
    aHL : System.Web.UI.WebControls.PlaceHolder;

    lNaziv:System.Web.UI.WebControls.HyperLink;
    lDeveloper:System.Web.UI.WebControls.Label;
    lAppType:System.Web.UI.WebControls.Label;
    lAppTypeLINK:System.Web.UI.WebControls.HyperLink;
    lAppPayType:System.Web.UI.WebControls.Label;
    lAppPayTypeLINK:System.Web.UI.WebControls.HyperLink;
    lDescription:System.Web.UI.WebControls.Label;

    Container: System.Web.UI.WebControls.DataGridItem;
		
		sAppType, sAppPayType : string;
begin
    aHL:=(Sender as System.Web.UI.WebControls.PlaceHolder);
    Container := (aHL.NamingContainer as System.Web.UI.WebControls.DataGridItem);

    lNaziv:=HyperLink.Create;
    lNaziv.Text := DataBinder.Eval((Container as DataGridItem).DataItem, 'ProductName').ToString;
    lNaziv.NavigateUrl:='webform1.aspx?id=' + DataBinder.Eval((Container as DataGridItem).DataItem, 'ProductID').ToString;
    lNaziv.CssClass:='oprg';

    aHL.Controls.Add(lNaziv);

    lDeveloper:=System.Web.UI.WebControls.Label.Create;
    lDeveloper.Text := '<br><b>' + 'Author: ' +  DataBinder.Eval((Container as DataGridItem).DataItem, 'Name').ToString + '</b>';
    lDeveloper.CssClass:='oprgsmall';

    aHL.Controls.Add(lDeveloper);

		case gShowBy of
			sbAppPayType:
			begin
				sAppType:=DataBinder.Eval((Container as DataGridItem).DataItem, 'AppType').ToString;
				lAppType:=System.Web.UI.WebControls.Label.Create;
    		lAppTypeLINK:=System.Web.UI.WebControls.HyperLink.Create;
				with lAppTypeLINK do
				begin
					Text:=sAppType;
					NavigateUrl:='webform3.aspx?apptype=' + sAppType;
					CssClass:='oprgsmall';
				end;
    		lAppType.Text := '<br>' + 'Category: ';// +  DataBinder.Eval((Container as DataGridItem).DataItem, 'AppType').ToString + '</b>';
    		lAppType.CssClass:='oprgsmall';
		    aHL.Controls.Add(lAppType);
    		aHL.Controls.Add(lAppTypeLINK);
			end; // case sbAppType
			sbAppType:
			begin
				sAppPayType:=DataBinder.Eval((Container as DataGridItem).DataItem, 'AppPayType').ToString;
  		  lAppPayType:=System.Web.UI.WebControls.Label.Create;
    		lAppPayTypeLINK:=System.Web.UI.WebControls.HyperLink.Create;
				with lAppPayTypeLINK do
				begin
					Text:=sAppPayType;
					NavigateUrl:='webform3.aspx?apppaytype=' + sAppPayType;
					CssClass:='oprgsmall';
				end;
		    lAppPayType.Text := '<br>' + 'Type: '; //+  DataBinder.Eval((Container as DataGridItem).DataItem, 'AppPayType').ToString + '</b>';
	  	  lAppPayType.CssClass:='oprgsmall';
	
		    aHL.Controls.Add(lAppPayType);
		    aHL.Controls.Add(lAppPayTypeLINK);
			end; //case sbAppType
		end; //case
		
    lDescription:=System.Web.UI.WebControls.Label.Create;
    lDescription.Text := '<br>' + LeftStr(DataBinder.Eval((Container as DataGridItem).DataItem, 'Description').ToString, 300) + '...';
    lDescription.CssClass:='oprgsmall';

    aHL.Controls.Add(lDescription);

end;


procedure TItemTemplate.InstantiateIn(container:System.Web.UI.Control);
 var
    aHL : System.Web.UI.WebControls.PlaceHolder;
    sBegin, sEnd, s : System.Web.UI.LiteralControl;
begin


 sBegin:=LiteralControl.create('<table WIDTH="100%" BORDER="0" BGCOLOR="#0000CC" CELLPADDING="3" CELLSPACING="1"><tr><td BGCOLOR="#FFFFFF" CLASS="formtext">');
 sEnd:=LiteralControl.create('</td></tr></table>');
 s:=LiteralControl.create('<table ALIGN="CENTER"><tr ALIGN="CENTER" VALIGN="MIDDLE"><td HEIGHT="2" BGCOLOR="#FFFFFF" ALIGN="CENTER"></td><td HEIGHT="2" BGCOLOR="#FFFFFF" ALIGN="CENTER"></td><td HEIGHT="2" BGCOLOR="#FFFFFF" ALIGN="CENTER"></td></tr></table>');


 aHL := System.Web.UI.WebControls.PlaceHolder.Create;

 aHL.add_DataBinding(DoDataBinding);

 container.Controls.Add(sBegin);
 container.Controls.Add(aHL);
 container.Controls.Add(sEnd);
 container.Controls.Add(s);
end;

procedure TCatGrid.MyOnPageIndexChanged(Sender: System.Object; e : DataGridPageChangedEventArgs);
begin
    CurrentPageIndex := e.NewPageIndex;
    DataBind;
end;

procedure TCatGrid.MyOnItemCreated(Sender : System.Object; e : DataGridItemEventArgs);
var
    itemType : ListItemType;
    pager : TableCell;
    lit : LiteralControl;
begin
try
    itemType := e.Item.ItemType;
    If (itemType = ListItemType.Pager) Then
    begin
        lit:=LiteralControl.Create;
        lit.Text:='Found ' + IntToStr((DataSource as DataTable).Rows.Count) + ' record(s). Displaying ' + IntToStr(1 + CurrentPageIndex * PageSize) + ' to ' + IntToStr(PageSize + CurrentPageIndex * PageSize) + '.';
        lit.Text:= lit.Text + ' Goto page: ';
        //lit.ID:='CatPagerDescription';
        pager := (e.Item.Controls[0] as TableCell);
        pager.Controls.AddAt(0,lit);
				lit.Free;
    end;
finally
end;
end;

constructor TCatGrid.Create;
var
  dgColumn : TemplateColumn;
begin
    inherited create;

    Add_PageIndexChanged(MyOnPageIndexChanged); 
    Add_ItemCreated(MyOnItemCreated); 

    AutoGenerateColumns := False;
    ShowFooter := False;
    ShowHeader := False;
    Width := System.Web.UI.WebControls.Unit.Percentage(100);
    BorderWidth := System.Web.UI.WebControls.Unit.Pixel(0);
    GridLines := System.Web.UI.WebControls.GridLines.None;
		//CellPadding := 2;

    
    AllowPaging := True;
    PageSize:=5;

    PagerStyle.Mode := PagerMode.NumericPages;
		//PagerStyle.NextPageText := 'Next ';
		//PagerStyle.PrevPageText := ' Previous';
    PagerStyle.PageButtonCount := 5;
    PagerStyle.HorizontalAlign := System.Web.UI.WebControls.HorizontalAlign.Left;
    PagerStyle.Position:=PagerPosition.Top;
    PagerStyle.cssClass:='CatPager';

    dgColumn := TemplateColumn.Create;
    with dgColumn do
    begin
        Initialize;
        ItemTemplate := TItemTemplate.create;
    end;
    Columns.Add(dgColumn);
		

end;


end.
